

///**
// ******************************************************************************
// *
// * @file        BLE_SPI.C
// * @brief       BLE_MG126 SPI c Code. 
// *
// * @par         Project
// *              MG32x02z
// * @version     V1.03
// * @date        2021/06/23
// * @author      Megawin Software Center
// * @copyright   Copyright (c) 2020 MegaWin Technology Co., Ltd.
// *              All rights reserved.
// *
// ******************************************************************************* 
// * @par Disclaimer
// * The Demo software is provided "AS IS" without any warranty, either
// * expressed or implied, including, but not limited to, the implied warranties
// * of merchantability and fitness for a particular purpose. The author will
// * not be liable for any special, incidental, consequential or indirect
// * damages due to loss of data or any other reason.
// * These statements agree with the world wide and local dictated laws about
// * authorship and violence against these laws.
// *******************************************************************************
//  @if HIDE
// * Modify History:
// * #001_Hades_20200428
// *  >> Addition function "SPI0_Init"
// *
// * #002_Hades_20200429
// *  >> Addition function "SysClk8to48", "SysClk48to8", "DisableEnvINT", 
// *     "EnableEnvINT", "UpdateLEDValueAll", "McuGotoSleepAndWakeup" and 
// *     "aes_encrypt_HW".
// *
// * #003_Hades_20210511
// *  >> Function support "SPIx_Init", "SPI_WriteBuf" and "SPI_ReadBuf".
// *  >> Modify CK_AHB frequency support 12MHz, 24MHz and 48MHz, but not support 32MHz
// *
// * #004_Hades_20210616
// *  >> SPI0 support SPI access failure table. Others condition CK_AHB = 12MHz/24MHz/48MHz, 
// *     ARM compiler version V5/V6 and Optimization -O0 ~ -O3 is success.  
// *     +---------+--------------+--------------+----------------+                                           
// *     |         |              |              | Result         |
// *     | Project | ARM Compiler | Optimization +----------------+
// *     | (SPI0)  |              |              | CK_AHB = 12MHz | 
// *     +---------+--------------+--------------+----------------+
// *     | FA217   | Version 6    | -O0          | Connect FALL   |
// *     +---------+--------------+--------------+----------------+
// *     | FA239   | Version 6    | -O0          | Connect FALL   |
// *     +---------+--------------+--------------+----------------+
// *     | JA243   | Version 5    | -O0          | Connect FALL   |
// *     +---------+--------------+--------------+----------------+
// *     | JA243   | Version 6    | -O0          | Connect FALL   |
// *     +---------+--------------+--------------+----------------+ 
// *
// *  >> URT0~URT3 support SPI access failure table. Others condition CK_AHB = 12MHz/24MHz/48MHz, 
// *     ARM compiler version V5/V6 and Optimization -O0 ~ -O3 is success.  
// *     +---------+--------------+--------------+----------------+                                           
// *     |         |              |              |                |
// *     | Project | ARM Compiler | Optimization +----------------+
// *     | (URTx)  |              |              | CK_AHB = 12MHz | 
// *     +---------+--------------+--------------+----------------+
// *     | FA217   | Version 6    | -O0          | Connect FALL   |
// *     +---------+--------------+--------------+----------------+
// *     | FA239   | Version 6    | -O0          | Connect FALL   |
// *     +---------+--------------+--------------+----------------+
// *     | JA243   | Version 5    | -O0          | Connect FALL   |
// *     +---------+--------------+--------------+----------------+
// *     | JA243   | Version 5    | -O2          | mobile TX      |
// *     |         |              |              | trigger failure|
// *     +---------+--------------+--------------+----------------+
// *     | JA243   | Version 6    | -O0          | Connect FALL   |
// *     +---------+--------------+--------------+----------------+ 
// *
// * #005_Hades_20210623
// *  >> Rename "BLE_SPI0_Library.lib" to "BLE_SPI.c".
// *
// *******************************************************************************
// */


/* Includes ------------------------------------------------------------------*/
//#include "MG0404A_BSP.h"
//#include "MG32x02z__Common_DRV.h"
//#include "MG32x02z_Common_MID.h"
//#include "MG32x02z_SPI_MID.h"
#include "MG32x02z.h"

/* Wizard menu ---------------------------------------------------------------*/
/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/

/* Private function prototypes -----------------------------------------------*/
void BLE_SPI_Null(void);

/* Private variables ---------------------------------------------------------*/
////volatile uint8_t SPI_RDAT;                      /* Add volatile */
//volatile boolean CPU_CLK_FAST_ENABLE = FALSE;   /* Add volatile */

/* Exported variables --------------------------------------------------------*/
/* Exported functions --------------------------------------------------------*/
/* External vairables --------------------------------------------------------*/

/**
 *******************************************************************************
 * @brief	  Prevent unused c file compilcation warning
 * @details     
 * @return      
 * @exception   
 * @note      
 * @par         
 *******************************************************************************
 */
void BLE_SPI_Null(void)
{
    __NOP();
}


